package RLC_Circuit


  import Modelica.SIunits.*;
  //Voltage and Current are types defined in SIunits package of Modelica. These types are used frequently in this package //

connector pin
    Voltage v;
    flow Current i;
    annotation(Icon(coordinateSystem(extent = {{-100, 100}, {100, -100}}, grid = {2, 2}), graphics = {Rectangle(extent = {{-100, 100}, {100, -100}}, lineColor = {0, 0, 255}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid)}));
end pin;

class Ground
pin p annotation(Placement(visible = true, transformation(origin = {2, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    p.v = 0;
    annotation(Icon(coordinateSystem(initialScale = 0.1), graphics = {Line(origin = {0, 12}, points = {{0, -10}, {0, 10}, {0, 10}})}));
end Ground;

class VoltageSource
    pin p annotation(Placement(transformation(extent = {{-110, 10}, {-90, -10}})));
    pin n annotation(Placement(transformation(extent = {{90, 10}, {110, -10}})));
    Voltage Vs;
    Current Is;
    parameter Voltage Vo = 10 "Amplitude";
    parameter Real f(unit = "Hz") = 1 "frequency";
    constant Real PI = 3.14;
  equation
    Vs = p.v - n.v;
    p.i + n.i = 0;
    Is = p.i;
    Vs = Vo * sin(2 * PI * f * time);
    annotation(Icon(coordinateSystem(extent = {{-100, 100}, {100, -100}}, grid = {2, 2}), graphics = {Line(origin = {0, 0}, points = {{-90, 0}, {-20, 0}}, color = {0, 0, 255}), Ellipse(origin = {0, 0}, extent = {{-20, 20}, {20, -20}}, lineColor = {255, 0, 0}), Line(origin = {0, 0}, points = {{20, 0}, {90, 0}}, color = {0, 0, 255}), Text(origin = {0, 0}, extent = {{-20, 60}, {20, 40}}, textString = "Vo = %Vo")}));
end VoltageSource;

class Resistor
    pin p annotation(Placement(transformation(extent = {{-110, 10}, {-90, -10}})));
    pin n annotation(Placement(transformation(extent = {{90, 10}, {110, -10}})));
    Voltage Vr "Voltage across Resistor ";
    Current Ir "Current through Resistor";
    parameter Real R(unit = "ohm") = 5 "Resistance";
  equation
    Vr = p.v - n.v;
    p.i + n.i = 0;
    Ir = p.i;
    Vr = R * Ir;
end Resistor;

class Capacitor
    pin p annotation(Placement(transformation(extent = {{-110, 10}, {-90, -10}})));
    pin n annotation(Placement(transformation(extent = {{90, 10}, {110, -10}})));
    Voltage Vc "Voltage across Capacitor";
    Current Ic "Current across Capacitor";
    parameter Real C(unit = "F") = 0.01 "Capacitance";
  equation
    C * der(Vc) = Ic;
    Vc = p.v - n.v;
    0 = p.i + n.i;
    Ic = p.i;
end Capacitor;

class Inductor
    pin p annotation(Placement(transformation(extent = {{-110, 10}, {-90, -10}})));
    pin n annotation(Placement(transformation(extent = {{90, 10}, {110, -10}})));
    Voltage Vl "Voltage across Inductor";
    Current Il "Current across Inductor";
    parameter Real L(unit = "H") = 0.5 "Inductance";
  equation
    Vl = L * der(Il);
    Vl = p.v - n.v;
    0 = p.i + n.i;
    Il = p.i;
end Inductor;

class circuit
  equation

  end circuit;
end RLC_Circuit;